
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <time.h>
#include <signal.h>
#include <sys/time.h>

#include <ifaddrs.h>
#include <errno.h>



#define MSG_SIZE 40			// message size

#define SERVER_ADDRESS  "10.3.52.19" /// location of Raspberry PI

typedef struct photo
{ // holds info with inormation to talk to raspberry pi
	int client_socket;
	        //char buffer[MSG_SIZE];
	        ssize_t len;
	        struct sockaddr_in remote_addr;
	        char buffer[BUFSIZ];
	        int file_size;
	        FILE *received_file;
	        int remain_data;
	        int PORT_NUMBER;

}photo;



void dostuff(int , int, photo*); 			// function prototype
void error(const char *msg)
{
    perror(msg);
    exit(0);
}

void write_info (int pm_number, int car_at_pm, int ticket_car, photo * photo_info)
{//write_info(int pm_number, int car_at_pm, int ticket_car);

// write info to files for each pm_meter

    //char * parking_meter_number;// holds the parking meter number
    //char * car_at_meter;// hodls info if car at meter 1 yes 0 no
    //char * ticket; // holds info if ticket should be given 1 yes 0 no

    //int pm_number; // holds int value for parking_meter_number
    //int car_at_pm; // holds int value of car_at_meter
    //int ticket_car; // holds int value of ticket


    // check if ticket agent should be sent if so get time of ticket agent noification

    time_t notification_time;

    char output_file_name[35];
    char *first= "Parking_Meter_";
    char *last = ".txt";
    char random_buffer[3];

    //Create file name for each parking meter.
    strcpy(output_file_name, first);
    snprintf(random_buffer, sizeof(random_buffer), "%d", pm_number);
    strcat(output_file_name, random_buffer);
    strcat(output_file_name, last);

    //printf("%s\n ", output_file_name);

    FILE * fp = fopen(output_file_name, "a"); // open file
    if (fp == NULL)
        printf("PROBELM WITH OPEING OUTPUT FILE\n");

    fseek(fp, 0,SEEK_END); // search to the end of the file

    // now decided which infomation to write

    if (car_at_pm == 1) // car is there
    {
        // check if ticket should be given
        if ( ticket_car == 1 ) // ticket car at pm_number
        {
            time ( &notification_time );
            printf ( "Ticket agent notified to ticket parking meter: %d at time of %s",pm_number, ctime (&notification_time) );

            // call RP pie for picture and save it here.

            char * time =ctime (&notification_time);
            int n;

            photo_info->buffer[0] = '1';
        	// send message
    	 	n = write(photo_info->client_socket,photo_info->buffer,strlen(photo_info->buffer));	// sendto() could be used.
        	if (n < 0)
        		error("ERROR writing to socket");

         /* Receiving file size */

        	recv(photo_info->client_socket, photo_info->buffer, BUFSIZ, 0);// get the file size of the file to be sent

        	photo_info->file_size = atoi(photo_info->buffer);

        	// name of file will be parking meter number and time
        	char output_file_name[35];
        	char *first= "Parking_Meter_";
        	char *last = ".ppm";
            char random_buffer[3];

        	//Create file name for each parking meter.
            strcpy(output_file_name, first);
            snprintf(random_buffer, sizeof(random_buffer), "%d ", pm_number);
            strcat(output_file_name, random_buffer);
        	strcat(output_file_name, time);
            strcat(output_file_name, last);

        	photo_info->received_file = fopen(output_file_name, "w");

            if ( photo_info->received_file == NULL)
            {
            	fprintf(stderr, "Failed to open file foo --> %s\n", strerror(errno));

            	exit(EXIT_FAILURE);
            }

            photo_info->remain_data =  photo_info->file_size;
        	int i;

            for ( i  = 0; i <  photo_info->remain_data; i ++) //
            {
            	 photo_info->len = recv( photo_info->client_socket,  photo_info->buffer, BUFSIZ, 0);// 

            	fwrite( photo_info->buffer, sizeof(char),  photo_info->len,  photo_info->received_file);
            	photo_info->remain_data -=  photo_info->len;

        	//   printf("phto remain: %d   and photo len: %d  i:%d \n",photo_info->remain_data,photo_info->len, i );
            }


        	fclose( photo_info->received_file);

            fprintf(fp, "Parking meter : %d Currently has a car which needs a ticket. Ticket agent had been notified at this time : %s \n", pm_number,time);//ctime (&notification_time));

        }
        else // car at meter but no ticket to be given
        {
            time ( &notification_time );
            fprintf(fp, "Parking meter : %d Currently has a car, but no ticket needs to be give at this time : %s \n", pm_number,ctime (&notification_time));
        }

    }
    else // no car at meter
    {
        time ( &notification_time );
        fprintf(fp, "Parking meter : %d Currently has no car at this time : %s \n", pm_number,ctime (&notification_time));

    }

    fclose(fp);

}



int main(int argc, char *argv[])
{

	  if (argc < 2) // add back in to have server port
	    {
	       printf("usage: %s port for client and server and port number camera \n", argv[0]);
	        exit(0);
	    }

    int sockfd, newsockfd, portno, pid, j = 0;
    socklen_t clilen;
    struct sockaddr_in serv_addr, cli_addr;

    photo *photo_info = NULL;
    photo_info = malloc(sizeof(photo));

    if ( photo_info == NULL )
    {
        printf("Malloc problem with photo_info");
        return 0;
    }

   photo_info->file_size =0;
   photo_info->remain_data = 0;


   //*** setup socket info for camera
   /* Zeroing remote_addr struct */
   memset(&photo_info->remote_addr, 0, sizeof(photo_info->remote_addr));

   /* Construct remote_addr struct */
   photo_info->remote_addr.sin_family = AF_INET;
   photo_info->PORT_NUMBER = atoi(argv[2]);
   inet_pton(AF_INET, SERVER_ADDRESS, &(photo_info->remote_addr.sin_addr));
   photo_info->remote_addr.sin_port = htons(photo_info->PORT_NUMBER);

   /* Create client socket */
   photo_info->client_socket = socket(AF_INET, SOCK_STREAM, 0);
   if (photo_info->client_socket == -1)
   {
	   fprintf(stderr, "Error creating socket --> %s\n", strerror(errno));

       exit(EXIT_FAILURE);
   }

   /* Connect to the server */
   if (connect(photo_info->client_socket, (struct sockaddr *)&photo_info->remote_addr, sizeof(struct sockaddr)) == -1)
   {
	   fprintf(stderr, "Error on connect --> %s\n", strerror(errno));

       exit(EXIT_FAILURE);
   }

  //  char * parking_meter_number;// holds the parking meter number
  //  char * car_at_meter;// hodls info if car at meter 1 yes 0 no
   // char * ticket; // holds info if ticket should be given 1 yes 0 no

   // int pm_number; // holds int value for parking_meter_number
   // int car_at_pm; // holds int value of car_at_meter
   // int ticket_car; // holds int value of ticket

    //*****************************************HERE

    char hostn[400]; //placeholder for the hostname
    struct hostent *hostIP; //placeholder for the IP address

    //if the gethostname returns a name then the program will get the ip address using gethostbyname
    if((gethostname(hostn, sizeof(hostn))) == 0)
    {
        hostIP = gethostbyname(hostn); //the netdb.h function gethostbyname
       // printf("IP address: %s\n", inet_ntoa(*(struct in_addr*)hostIP->h_addr));
    }
    else
    {
        printf("ERROR:FC4539 - IP Address not found."); //error if thehostname is not found
    }
    //********************************************

    sockfd = socket(AF_INET, SOCK_STREAM, 0); // Creates socket. Connection based.
        if (sockfd < 0)
       	 error("ERROR opening socket");

        // fill in fields
    bzero((char *) &serv_addr, sizeof(serv_addr));
	portno = atoi(argv[1]);	// get port number from input
	serv_addr.sin_family = AF_INET;		 // symbol constant for Internet domain
	serv_addr.sin_addr.s_addr = INADDR_ANY; // IP address of the machine on which
       											 // the server is running
    serv_addr.sin_port = htons(portno);	 // port number

	// binds the socket to the address of the host and the port number
	if (bind(sockfd, (struct sockaddr *) &serv_addr, sizeof(serv_addr)) < 0)
    	error("ERROR on binding");

    listen(sockfd, 5);			// listen for connections
	clilen = sizeof(cli_addr);	// size of structure

    // Message that will come in on buffer will be in this format - all ints.
    // Parking Meter Number, car at metter =1 no car = 0; if should ticket =1  else =0;

    // picture will be at the end in what ever format it needs to be


     while (1)
     {
            // blocks until a client connects to the server
    	 newsockfd = accept(sockfd, (struct sockaddr *) &cli_addr, &clilen);
         if (newsockfd < 0)
             error("ERROR on accept");

          j++;		// counter for the connections that are established.
          pid = fork();
          if (pid < 0)
              error("ERROR on fork");

          if (pid == 0)	// child process
          {
        	  printf("Connection #%d created\n",j);
             // close(sockfd);			// close socket // keep open
              dostuff(j , newsockfd, photo_info);	// call function that handles communication
              exit(0);
           }
           else			// parent
           {
            close(newsockfd);
            signal(SIGCHLD,SIG_IGN);	// to avoid zombie problem
           }



    }// end of while (1)
    close(sockfd);
    return 0;
}


void dostuff (int j, int sock, photo* photo_info)
{
	char * parking_meter_number;// holds the parking meter number
	    char * car_at_meter;// hodls info if car at meter 1 yes 0 no
	    char * ticket; // holds info if ticket should be given 1 yes 0 no

	    int pm_number; // holds int value for parking_meter_number
	    int car_at_pm; // holds int value of car_at_meter
	    int ticket_car; // holds int value of ticket


	while (1){
   int n;
   char buffer[MSG_SIZE];

   bzero(buffer,MSG_SIZE);
   n = read(sock,buffer,MSG_SIZE-1);
   if (n < 0)
	   error("ERROR reading from socket");
  // printf("Here is the message from parking meter %d: %s\n",j, buffer);


	   parking_meter_number = strtok( buffer, " "); // holds the parking meter number
            //printf("parking_meter_number %s\n", parking_meter_number);

           pm_number = atoi(parking_meter_number);
           //printf("parking_meter_number %d\n", pm_number);

           car_at_meter = strtok(NULL, " "); // hodls info if car at meter 1 yes 0 no
           //printf("car_at_meter %s\n", car_at_meter);

           car_at_pm = atoi(car_at_meter);
           //printf("car_at_pm %d\n", car_at_pm);

           ticket = strtok(NULL, " "); //  holds info if ticket should be given 1 yes 0 no
           //printf("ticket %s\n", ticket);

           ticket_car = atoi(ticket); // holds int value of ticket
           //printf("ticket %d\n", ticket_car);

       //************* Now look at parking meter number to write info and decied if ticket agent should be sent

           write_info(pm_number, car_at_pm, ticket_car, photo_info);



   //n = write(sock,"I got your message",18); // remove this portion since the client will not be looking for a message back
   //if (n < 0)
	  // error("ERROR writing to socket");
	}
}

